#include "compat.h"

#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#include "net.h"
#include "opennet.h"

#ifndef MSG_WAITALL
#define MSG_WAITALL 0
#endif

/*
 * Legacy stub, please ignore.
 */
int opennet_init(void) {
	return(0);
}

static int parse_url(char *url, char **scheme, char **user, char **pass, char **host, int *port, char **path) {
	char *tmptr, *schemeptr, *pathptr, *userptr, *passptr, *hostptr, *portptr;

	if (!url) {
		return(-1);
	}

	tmptr = strstr(url, "://");
	if (!tmptr) {
		return(-1);
	}

	if (strlen(tmptr) <= 3) {
		return(-1);
	}

	*tmptr = '\0';
	schemeptr = url;

	tmptr += 3;

	pathptr = strchr(tmptr, '/');

	if (pathptr) {
		*pathptr = '\0';
		pathptr++;
	} else {
		pathptr = "";
	}

	hostptr = strchr(tmptr, '@');
	if (hostptr) {
		*hostptr = '\0';
		hostptr++;
		userptr = tmptr;
		passptr = strchr(userptr, ':');
		if (passptr) {
			*passptr = '\0';
			passptr++;
		}
	} else {
		userptr = NULL;
		passptr = NULL;
		hostptr = tmptr;
	}

	portptr = strchr(hostptr, ':');
	if (portptr) {
		*portptr = '\0';
		portptr++;
		*port = strtoul(portptr, NULL, 10);
	} else {
		if (strcasecmp(schemeptr, "http") == 0) {
			*port = 80;
		} else if (strcasecmp(schemeptr, "ftp") == 0) {
			*port = 21;
		} else {
			*port = 0;
		}
	}

	*scheme = schemeptr;
	*user = userptr;
	*pass = passptr;
	*host = hostptr;
	*path = pathptr;

	return(0);
}

static int open_net_http(char *user, char *pass, char *host, int port, char *path, int flags) {
	ssize_t send_ret, recv_ret;
	char httpcmd[4096], charbuf, httpreply[1024], *http_response;
	int fd;
	int snprintf_ret;
	int http_response_code = 0;
	int newlinecount = 0, linenum = 0, i = 0;

	fd = net_connect_tcp(host, port);

	if (fd < 0) {
		return(-1);
	}

	snprintf_ret = snprintf(httpcmd, sizeof(httpcmd), "GET /%s HTTP/1.0\015\012Host: %s\015\012\015\012", path, host);

	if (snprintf_ret >= sizeof(httpcmd)) {
		return(-1);
	}

	send_ret = send(fd, httpcmd, snprintf_ret, 0);
	if (send_ret != snprintf_ret) {
		net_close(fd);
		return(-1);
	}

	while (1) {
		recv_ret = recv(fd, &charbuf, 1, MSG_WAITALL);

		if (charbuf == '\015' || charbuf == '\012') {
			if (i > 0) {
				httpreply[i] = '\0';
				if (linenum == 0) {

					if (strlen(httpreply) < 9) {
						net_close(fd);
						return(-1);
					}

					http_response = httpreply + 9;
					http_response_code = strtoul(http_response, NULL, 10);
					switch (http_response_code) {
						case 200:
						case 301:
						case 302:
							break;
						case 404:
							CHECKPOINT;
						default:
							net_close(fd);
							return(-1);
					}
				} else {
					if (http_response_code == 301 || http_response_code == 302) {
						if (strncasecmp(httpreply, "Location:", 9) == 0) {
							net_close(fd);
							return(open_net(httpreply + 10, flags, 0));
						}
					}
				}
			}
			newlinecount++;
			linenum++;
			i = 0;
		} else {
			newlinecount = 0;
			httpreply[i++] = charbuf;
		}


		if (newlinecount == 4) {
			break;
		}

		if (recv_ret <= 0) {
			net_close(fd);
			return(-1);
		}
	}

	return(fd);
}

static int open_net_ftp(char *user, char *pass, char *host, int port, char *path, int flags) {
	return(-1);
}

static int open_net_internal(const char *pathname, int flags, mode_t mode, int *socket) {
	char *pathname_dup;
	char *scheme, *user, *pass, *host, *path;
	int port = 0;
	int parse_ret;
	int retval = -1;

	*socket = 0;

	if (!pathname) {
		return(open(pathname, flags, mode));
	}

	pathname_dup = strdup(pathname);

	if (!pathname_dup) {
		return(open(pathname, flags, mode));
	}

	parse_ret = parse_url(pathname_dup, &scheme, &user, &pass, &host, &port, &path);

	if (parse_ret < 0 || port == 0 || !host || !scheme) {
		free(pathname_dup);
		return(open(pathname, flags, mode));
	}

	if (strcasecmp(scheme, "http") == 0) {
		retval = open_net_http(user, pass, host, port, path, flags);
	}

	if (strcasecmp(scheme, "ftp") == 0) {
		retval = open_net_ftp(user, pass, host, port, path, flags);
	}

	free(pathname_dup);

	if (retval < 0) {
		retval = open(pathname, flags, mode);
	} else {
		*socket = 1;
	}

	return(retval);
}

NETFILE *fopen_net(const char *pathname, const char *mode) {
	int is_sock;
	NETFILE *ret;

	ret = malloc(sizeof(*ret));

	if (!ret) {
		return(NULL);
	}

	ret->fd = open_net_internal(pathname, O_RDONLY, 0666, &is_sock);

	if (ret->fd < 0) {
		free(ret);
		return(NULL);
	}

	ret->bufsize_s = ret->bufsize = 32768;
	ret->buf_s = ret->buf = malloc(ret->bufsize);
	ret->bufused = 0;
	ret->eof = 0;
	ret->socket = is_sock;

	if (is_sock) {
//		ret->recv_func = recv;
//		ret->send_func = send;
	} else {
//		ret->recv_func = read;
//		ret->send_func = write;
	}

	return(ret);
}

int feof_net(NETFILE *stream) {
	if (!stream) {
		return(-1);
	}

	return(stream->eof);
}

size_t fread_net(void *ptr, size_t size, size_t nmemb, NETFILE *stream) {
	ssize_t recv_ret;
	size_t retval;
	int bytes_to_copy;

	if (!stream) {
		return(0);
	}

	if (stream->fd >= 0) {
		while (stream->bufused < (size * nmemb)) {
			if (stream->socket) {
				recv_ret = recv(stream->fd, stream->buf + stream->bufused, stream->bufsize - stream->bufused, MSG_WAITALL);
			} else {
				recv_ret = read(stream->fd, stream->buf + stream->bufused, stream->bufsize - stream->bufused);
			}

			if (recv_ret <= 0) {
				net_close(stream->fd);
				stream->fd = -1;
				break;
			}

			stream->bufused += recv_ret;
		}
	}

	if (stream->bufused == 0) {
		if (stream->fd < 0) {
			stream->eof = 1;
		}
		return(0);
	}

	bytes_to_copy = (size * nmemb);

	if (stream->bufused < bytes_to_copy) {
		bytes_to_copy = stream->bufused;
	}

	memcpy(ptr, stream->buf, bytes_to_copy);
	stream->buf += bytes_to_copy;
	stream->bufused -= bytes_to_copy;
	stream->bufsize -= bytes_to_copy;

	if (stream->bufused == 0) {
		stream->buf = stream->buf_s;
		stream->bufsize = stream->bufsize_s;
	}

	retval = bytes_to_copy / size;

	return(retval);
}

char *fgets_net(char *s, int size, NETFILE *stream) {
	ssize_t recv_ret;
	int bytes_to_copy;
	char *stopptr;

	if (!stream) {
		return(NULL);
	}

	if (stream->fd >= 0) {
		while (stream->bufused < size) {
			if (stream->socket) {
				recv_ret = recv(stream->fd, stream->buf + stream->bufused, stream->bufsize - stream->bufused, MSG_WAITALL);
			} else {
				recv_ret = read(stream->fd, stream->buf + stream->bufused, stream->bufsize - stream->bufused);
			}

			if (recv_ret <= 0) {
				net_close(stream->fd);
				stream->fd = -1;
				break;
			}

			stream->bufused += recv_ret;

			if (memchr(stream->buf, '\n', stream->bufused)) {
				break;
			}
		}
	}

	if (stream->bufused == 0) {
		if (stream->fd < 0) {
			stream->eof = 1;
		}
		return(NULL);
	}

	stopptr = memchr(stream->buf, '\n', stream->bufused);

	if (!stopptr) {
		stopptr = stream->buf + stream->bufused;
	} else {
		stopptr++;
	}

	bytes_to_copy = stopptr - stream->buf;

	if (size < bytes_to_copy) {
		bytes_to_copy = size;
	}

	memcpy(s, stream->buf, bytes_to_copy);

	if (bytes_to_copy < size) {
		s[bytes_to_copy] = '\0';
	} else {
		s[size - 1] = '\0';
	}

	stream->buf += bytes_to_copy;
	stream->bufused -= bytes_to_copy;
	stream->bufsize -= bytes_to_copy;

	if (stream->bufused == 0) {
		stream->buf = stream->buf_s;
		stream->bufsize = stream->bufsize_s;
	}

	return(s);
}

int fclose_net(NETFILE *stream) {
	int fd;
	int retval;
	int is_sock;

	if (!stream) {
		return(-1);
	}

	fd = stream->fd;
	is_sock = stream->socket;

	if (stream->buf_s) {
		free(stream->buf_s);
	}

	free(stream);

	if (is_sock) {
		retval = net_close(fd);
	} else {
		retval = close(fd);
	}

	return(retval);
}

int open_net(const char *pathname, int flags, mode_t mode) {
	int tmp;

	return(open_net_internal(pathname, flags, mode, &tmp));
}


ssize_t read_net(int fd, void *buf, size_t count) {
	ssize_t retval = -1;
	ssize_t read_ret;
	int socket = 0;
#ifdef HAVE_GETPEERNAME
	int gpn_ret;
	struct sockaddr_in *tmp = NULL;
	int tmplen;

	tmplen = sizeof(tmp);

	gpn_ret = getpeername(fd, (struct sockaddr *) tmp, &tmplen);

	if (gpn_ret >= 0) {
		socket = 1;
	}
#endif

	while (count) {
		if (socket) {
			read_ret = recv(fd, buf, count, 0);
		} else {
			read_ret = read(fd, buf, count);
		}

		if (read_ret == 0) {
			break;
		}

		if (read_ret < 0) {
			retval = read_ret;
			break;
		}

		count -= read_ret;
		buf += read_ret;
	}

	return(retval);
}

off_t lseek_net(int filedes, off_t offset, int whence) {
	return(-1);
}

int fseek_net(NETFILE *stream, long offset, int whence) {
	return(-1);
}
