/*
 * Copyright (C) 2001, 2002, and 2003  Roy Keene
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *      email: libopennet@rkeene.org
 */

#ifndef _OPENNET_H 
#define _OPENNET_H
#include <sys/types.h>
#include <unistd.h>

#ifdef  __cplusplus
extern "C" {
#endif

/* Must be the first thing called in a program. */
int opennet_init(void);

/* Open a URL.  Same syntax as POSIX open(), except `mode' is required. */
int open_net(const char *pathname, int flags, mode_t mode);

/* Seek in a file or stream.  Same syntax as POSIX lseek(). */
off_t lseek_net(int filedes, off_t offset, int whence);

/* A more deterministic POSIX read(). */
ssize_t read_net(int fd, void *buf, size_t count);

#ifdef  __cplusplus
}
#endif

#endif
