AC_DEFUN(DC_DO_NETSET, [
  AC_SEARCH_LIBS(socket, socket nsl)
  AC_SEARCH_LIBS(gethostbyname, nsl)
  AC_SEARCH_LIBS(inet_aton, xnet, AC_DEFINE(HAVE_INET_ATON), AC_SEARCH_LIBS(inet_addr, nsl))
])


AC_DEFUN(DC_DO_VERSION, [
  AC_MSG_CHECKING(version number)
  VERSION=`sed s/\.\*\ VERSION\ //\;t\ x\;d\;:x\;s/\"//g\;q conf.h`
  AC_MSG_RESULT($VERSION)
  AC_SUBST(VERSION)
])

AC_DEFUN(DC_GET_SHEXT, [
  AC_SUBST(SOEXT)
  AC_MSG_CHECKING(what extension to use for shared objects)
  case "`uname -s`" in 
    HP-UX)
      SOEXT=sl
      ;;
    Darwin)
      SOEXT=dynlib
      ;;
    Win32)
      SOEXT=dll
      ;;
    *)
      SOEXT=so
      ;;
  esac
  AC_MSG_RESULT($SOEXT)
])

AC_DEFUN(DC_GET_SHARED, [
  AC_SUBST(SHARED)
  AC_MSG_CHECKING(how to create shared objects)

  OLD_LDFLAGS="$LDFLAGS"
  LDFLAGS="$LDFLAGS -shared"
  AC_TRY_LINK([#include <stdio.h>], [ printf("okay\n"); return(0); ], SHARED="-shared", SHARED="", SHARED="");
  if test -z "$SHARED"; then
    LDFLAGS="$OLD_LDFLAGS -fPIC -shared"
    AC_TRY_LINK([#include <stdio.h>], [ printf("okay\n"); return(0); ], SHARED="-fPIC -shared", SHARED="", SHARED="");
  fi
  if test -z "$SHARED"; then
    LDFLAGS="$OLD_LDFLAGS -fPIC -Wl,+s -shared"
    AC_TRY_LINK([#include <stdio.h>], [ printf("okay\n"); return(0); ], SHARED="-fPIC -Wl,+s -shared", SHARED="", SHARED="
");
  fi
  if test -z "$SHARED"; then
    LDFLAGS="$OLD_LDFLAGS -Wl,-G,-z,textoff"
    AC_TRY_LINK([#include <stdio.h>], [ printf("okay\n"); return(0); ], [ SHARED="-Wl,-G,-z,textoff" ], SHARED="", SHARED=
"");
  fi
  LDFLAGS="$OLD_LDFLAGS"
  AC_MSG_RESULT($SHARED)
])

