#ifndef _KE_PQUEUE_H_14Oct03
#define _KE_PQUEUE_H_14Oct03

#include "config.h"
#include <sys/socket.h>
#include <sys/types.h>
#include <inttypes.h>

typedef enum {
	PQ_NONE=0,
	PQ_IGNORE=1,
	PQ_COPY=2,
	PQ_DELETE=4,
} packet_queue_fl_t;

struct packet_queue;
struct packet_queue {
	/* PUBLIC */
	struct sockaddr *dest;
	socklen_t destlen;
	ssize_t datalen;
	void *data;

	/* PRIVATE */
	struct packet_queue *_next;
	packet_queue_fl_t flags;
};

typedef struct packet_queue packet_queue_t;


packet_queue_t *packet_queue_add(const packet_queue_fl_t flags, struct sockaddr *dest, const socklen_t destlen, const ssize_t datalen, void *data, packet_queue_t *tail);
packet_queue_t *packet_queue_init(void);
packet_queue_t *packet_queue_get(const int del);
packet_queue_t *packet_queue_getnext(const struct sockaddr *dest);
int packet_queue_cleanup(void *cleanfunc(packet_queue_t *));
int packet_queue_delete(packet_queue_t *node);
void packet_queue_print(void);
unsigned int packet_queue_length(void);

#endif
