#ifndef _KE_NET_H
#define _KE_NET_H

#include "config.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <inttypes.h>
#ifdef _XOPEN_SOURCE_EXTENDED
#include <arpa/inet.h>
#endif

/* Use the exported symbols if we are unoptimized */
#ifndef _FAST
#define _KE_NET_RET
int net_create_udp_sock(void);
int net_listen_udp(uint16_t port);
ssize_t net_send_udp(int sock, struct sockaddr *dest, size_t destlen, void *msg, size_t msglen);
#else
#define _KE_NET_RET static
#include "net.c"
#endif

#endif
