#include "config.h"
#include <inttypes.h>
#include <string.h>

#include "dendian.h"
#include "lanbdd.h"
#include "lanbd.h"
#include "net.h"


signed int cmd_read(struct lanbd_packet *pinfo) {
	char *p_buf=NULL;
	ssize_t p_buflen=0;

	DBG_ENTER("%p", pinfo);

	if (pinfo==NULL) return(-1);

	p_buf=pinfo->data;
	p_buflen=pinfo->datalen;
	p_buflen-=sizeof(pinfo->offset)+sizeof(pinfo->len);
	if (p_buflen<0) {
		PRINTERR("Invalid packet!  Too short.");
		return(-1);
	}
	pinfo->offset=de_readbuf(p_buf, sizeof(pinfo->offset)); p_buf+=sizeof(pinfo->offset);
	pinfo->len=de_readbuf(p_buf, sizeof(pinfo->len)); p_buf+=sizeof(pinfo->len);

	if ((pinfo->flags&PFL_BROADCAST)==PFL_BROADCAST) {
		/* XXX: Need export table! */
		CHECKPOINT;
		return(-1);
	}
//	PRINTERR("We need to find block %08x:%016llx", pinfo->device, pinfo->block);
	lanbd_senddata(pinfo->addr, pinfo->addrlen, "This is a test", 14, 1, READ_R, pinfo->device, pinfo->block, pinfo->offset);

	return(0);
}

signed int cmd_read_reply(struct lanbd_packet *pinfo, char *buf, uint32_t buflen) {
	signed int datalen=0;
	unsigned int ignorebytes=sizeof(pinfo->len)+sizeof(pinfo->offset);

	DBG_ENTER("%p", pinfo);

	if (pinfo==NULL) return(-1);

	/* We ignore the `uncommon' parts of the header that were passed to us. */
	datalen=pinfo->datalen-ignorebytes;
	if (buflen<datalen) datalen=buflen;

	memcpy(buf, pinfo->data+ignorebytes, datalen);

	return(datalen);
}
