#!/bin/sh

OSNAME=`uname -s | dd conv=lcase 2>/dev/null`
OSVER=`uname -r | cut -f 1-2 -d . | cut -f 1 -d -`
ARCH=`uname -m | dd conv=lcase 2>/dev/null | sed 's/^i.86$/i386/;s/^sun4u$/sparc64/;s/^sun4m$/sparc32/'`

INCDIR=`echo $0 | sed s/'\/[^\/]*$'/''/g`
INCFILE="${INCDIR}/incpre.inc"
INCSRC=`echo ${INCDIR}/{${OSNAME},default}{-${OSVER},}{-${ARCH},}`

SRCFILE=
for srcfile in ${INCSRC}; do 
	if [ -f "${srcfile}" ]; then
		SRCFILE="${srcfile}"
		break
	fi
done

if [ -z "${SRCFILE}" ]; then
	echo "No source file found!" >&2
	exit 1
fi

echo "include ${SRCFILE}" > ${INCFILE}
