#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>

#ifndef LICACCTFILE
#define LICACCTFILE "licenses-created.txt"
#endif

#include "license.h"
#include "config.h"

struct lic_entry {
	char *svc;
	char *ver;
	char *org;
	uint32_t liccnt;
	uint32_t licnum;
	time_t exp;
	uint64_t hash;
};

struct lic_entry **readfile(const char *filename, int *num) {
	char buf[2048]={0}, *buf_x=NULL;
	struct lic_entry **ret={0};
	struct lic_entry *tmp=NULL;
	FILE *fp=NULL;
	int i=0;

	ret=malloc(512*sizeof(struct lic_entry));

	fp=fopen(filename, "r");
	if (!fp) {
		if (num) *num=0;
		return(NULL);
	}

	while (!feof(fp)) {
		if (fgets(buf, sizeof(buf), fp)==NULL) break;
		if (buf[0]=='#') continue;

		tmp=malloc(sizeof(struct lic_entry));
		buf_x=buf;
		tmp->svc=strdup(strsep(&buf_x, "|"));
		tmp->ver=strdup(strsep(&buf_x, "|"));
		tmp->org=strdup(strsep(&buf_x, "|"));
		tmp->licnum=atoi(strsep(&buf_x, "|"));
		tmp->liccnt=atoi(strsep(&buf_x, "|"));
		tmp->exp=atoi(strsep(&buf_x, "|"));
		ret[i]=tmp;
		i++;
	}

	if (num) *num=i;
	if (i==0) {
		return(NULL);
	} else {
		return(ret);
	}
}

uint32_t getnextlicnum(void) {
	struct lic_entry **lics=NULL;
	int num=0;
	uint32_t ret=0;
	int i;

	lics=readfile(LICACCTFILE, &num);
	if (!lics) return(0);

	for (i=0; i<num; i++) {
		if ((lics[i]->licnum)>ret) ret=lics[i]->licnum;
	}
	return(ret+1);
}


int writeacctinfo(struct lic_entry *lic) {
	FILE *fp;
	struct lic_entry **lics=NULL;
	int num=0;
	int i;

	lics=readfile(LICACCTFILE, &num);
	if (!lics) num=0;

	for (i=0; i<num; i++) {
		if (lics[i]->licnum==lic->licnum) {
			return(-1);
		}
	}
	fp=fopen(LICACCTFILE, "a+");
	if (!fp) return(-1);
	fprintf(fp, "%s|%s|%s|%i|%i|%lu\n", lic->svc, lic->ver, lic->org, lic->licnum, lic->liccnt, (unsigned long) lic->exp);
	fclose(fp);

	return(0);
}


/*
 * lanbd|0.1|Naval Research|100|1|0|7870290712139572178
 */
int main(int argc, char **argv) {
	char *licfile=NULL;
	char lnbuf[2048];
	char entbuf[1024];
	struct lic_entry **lics, licent;
	int numents=0, i;

	if (argc>1) licfile=argv[1];

	if (licfile) {
		lics=readfile(licfile, &numents);
		for (i=0; i<numents; i++) {
			sprintf(lnbuf, "%s|%s|%s|%i|%i|%lu", lics[i]->svc, lics[i]->ver, lics[i]->org, lics[i]->licnum, lics[i]->liccnt, (unsigned long) lics[i]->exp);
			writeacctinfo(lics[i]);
			lics[i]->hash=license_csum(lnbuf);
			sprintf(lnbuf, "%s|%llu", strdup(lnbuf), lics[i]->hash);
			printf("%s\n", lnbuf);
		}
	} else {
		fprintf(stderr, "Service: ");
		fflush(stderr);
		fgets(entbuf, sizeof(entbuf), stdin);
		while (entbuf[strlen(entbuf)-1]<' ') entbuf[strlen(entbuf)-1]='\0';
		licent.svc=strdup(entbuf);
		fprintf(stderr, "Version: ");
		fgets(entbuf, sizeof(entbuf), stdin);
		while (entbuf[strlen(entbuf)-1]<' ') entbuf[strlen(entbuf)-1]='\0';
		licent.ver=strdup(entbuf);
		fprintf(stderr, "Organizational information: ");
		fgets(entbuf, sizeof(entbuf), stdin);
		while (entbuf[strlen(entbuf)-1]<' ') entbuf[strlen(entbuf)-1]='\0';
		licent.org=strdup(entbuf);
		fprintf(stderr, "Number of licenses: ");
		fgets(entbuf, sizeof(entbuf), stdin);
		while (entbuf[strlen(entbuf)-1]<' ') entbuf[strlen(entbuf)-1]='\0';
		licent.liccnt=atoi(entbuf);

		licent.exp=0;
		licent.licnum=getnextlicnum();

		sprintf(lnbuf, "%s|%s|%s|%i|%i|%lu", licent.svc, licent.ver, licent.org, licent.licnum, licent.liccnt, (unsigned long) licent.exp);
		writeacctinfo(&licent);
		licent.hash=license_csum(lnbuf);
		sprintf(lnbuf, "%s|%llu", strdup(lnbuf), licent.hash);
		printf("%s\n", lnbuf);
	}
	return(0);
}
