#include "config.h"
#include <sys/socket.h>
#include <sys/types.h>
#include <inttypes.h>
#include <string.h>
#include <stdlib.h>

#include "pqueue.h"
#include "lanbd.h"

/* XXX: Document this global variable! */
packet_queue_t *packet_queue=NULL;

/*
 * XXX: Document!
 */
packet_queue_t *packet_queue_init(void) {
	packet_queue_t *pqhead;

	/* If the packet queue has already been initialized, abort. */
	if (packet_queue!=NULL) return(NULL);

	pqhead=malloc(sizeof(packet_queue_t));
	if (pqhead==NULL) return(NULL);

	pqhead->flags=PQ_IGNORE;
	pqhead->_next=NULL;
	packet_queue=pqhead;

	return(pqhead);
}

/*
 * XXX: Document!
 */
static packet_queue_t *packet_queue_findtail(void) {
	packet_queue_t *ret=packet_queue;

	if (ret==NULL) return(NULL);

	while ((ret->_next)!=NULL) {
		ret=ret->_next;
	}

	return(ret);
}

/*
 * XXX: Document!
 */
packet_queue_t *packet_queue_add(const packet_queue_fl_t flags, struct sockaddr *dest, const socklen_t destlen, const ssize_t datalen, void *data, packet_queue_t *tail) {
	packet_queue_t *pq=NULL, *tail_real=NULL;
	void *data_copy=NULL, *dest_copy=NULL;

	/* Abort if the queue isn't initialized, don't initialize it! */
	if (packet_queue==NULL) return(NULL);

	/* We reject non-data packets. */
	if (data==NULL) return(NULL);

	if (tail==NULL) {
		tail_real=packet_queue_findtail();
	} else {
		tail_real=tail;
	}

	if (tail_real->_next) {
		tail_real=packet_queue_findtail();
	}

	/* If we've still not found the end, abort it. */
	if (tail_real==NULL) return(NULL);
	if (tail_real->_next) return(NULL);

	pq=malloc(sizeof(packet_queue_t));
	if (pq==NULL) return(NULL);

	pq->flags=flags;
	pq->destlen=destlen;
	pq->datalen=datalen;
	if (flags==PQ_COPY) {
		data_copy=malloc(datalen);
		dest_copy=malloc(destlen);
		if (data_copy==NULL || dest_copy==NULL) {
			if (data_copy) free(data_copy);
			if (dest_copy) free(dest_copy);
			free(pq);
			return(NULL);
		}
		memcpy(data_copy, data, datalen);
		memcpy(dest_copy, dest, destlen);
		pq->data=data_copy;
		pq->dest=dest_copy;
	} else {
		pq->data=data;
		pq->dest=dest;
	}

	pq->_next=tail_real->_next;
	tail_real->_next=pq;

	return(pq);
}

/*
 * XXX: Document!
 */
packet_queue_t *packet_queue_get(const int del) {
	packet_queue_t *ret=packet_queue;

	while (ret) {
		if ((ret->flags&PQ_IGNORE)!=PQ_IGNORE) {
			if (del) {
				ret->flags|=PQ_IGNORE|PQ_DELETE;
			} else {
				ret->flags|=PQ_IGNORE;
			}
			return(ret);
		}
		ret=ret->_next;
	}

	return(NULL);
}

/*
 * XXX: Document!
 */
int packet_queue_cleanup(void *cleanfunc(packet_queue_t *)) {
	packet_queue_t *node=NULL, *nextnode=NULL, *prevnode=NULL;
	int ret=0;

	node=packet_queue;

	while (node) {
		nextnode=node->_next;
		if ((node->flags&PQ_DELETE)==PQ_DELETE) {
			prevnode->_next=nextnode;

			if (cleanfunc) cleanfunc(node);
			/* If this node was told to copy, free() it as well. */
			if ((node->flags&PQ_COPY)==PQ_COPY) {
				free(node->dest);
				free(node->data);
			}
			free(node);
			ret++;
		} else {
			prevnode=node;
		}
		node=nextnode;
	}

	return(ret);
}

int packet_queue_delete(packet_queue_t *node) {
	if (node==NULL) return(-1);

	node->flags|=PQ_DELETE;
	return(0);
}

/*
 * XXX: Document!
 */
packet_queue_t *packet_queue_getnext(const struct sockaddr *dest) {
	return(NULL);
}

#ifdef DEBUG
void packet_queue_print(void) {
	packet_queue_t *node;

	node=packet_queue;

	while (node) {
		printf("%p{%s}->", node, (char *) node->data);
		if (node==node->_next) {
			PRINTERR("Something is hosed!");
			break;
		}
		node=node->_next;
	}
	printf("\n");
}

unsigned int packet_queue_length(void) {
	packet_queue_t *node;
	int retval=0;

	node=packet_queue;

	while (node) {
		retval++;
		node=node->_next;
	}

	return(retval-1);
}
#else
void packet_queue_print(void) { return; }
unsigned int packet_queue_length(void) { return(0); }
#endif
