#include "config.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <inttypes.h>
#include <unistd.h>
#ifdef _XOPEN_SOURCE_EXTENDED
#include <arpa/inet.h>
#endif

/* If we're being optimized, don't make any symbols. */
#if defined(_KE_NET_H) || !defined(_FAST)
#include "net.h"


/* XXX: document! */
_KE_NET_RET int net_create_udp_sock(void) {
	int sockoptval=0;
	socklen_t sockoptlen=sizeof(sockoptval);
	int sockopt_ret=-1;
	int sock=-1;

	/* Create our UDP socket. */
	sock=socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);
	if (sock<0) return(-1);
	
	/* Enable broadcast reception/transmission. */
	sockoptval=1;
	sockopt_ret=setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &sockoptval, sockoptlen);

	return(sock);
}

/* XXX: document! */
_KE_NET_RET ssize_t net_send_udp(int sock, struct sockaddr *dest, size_t destlen, void *msg, size_t msglen) {
	ssize_t retval=0;
	int real_sock=sock;

	if (sock<0) {
		real_sock=net_create_udp_sock();
		if (real_sock<0) return(-1);
	}

	retval=sendto(real_sock, msg, msglen, 0, dest, destlen);

	if (sock<0) close(real_sock);
	return(retval);
}


/*
 * SYNOPSIS
 *    int net_listen_udp(
 *          const uint16_t port
 *        );
 * ARGUMENTS
 *    const uint16_t port    Port to bind to for listening
 *
 * DESCRIPTION
 *    This function creates a UDP socket and binds it to a specific
 *    port for further reading.
 *
 * RETURN VALUE
 *    On success, the bound socket descriptor is returned, on error
 *    -1 is returned.
 */
_KE_NET_RET int net_listen_udp(const uint16_t port) {
	struct sockaddr_in myaddr;
	socklen_t myaddrlen=sizeof(myaddr);
	int bind_ret=0;
	int sockfd=0;

	myaddr.sin_family=AF_INET;
	myaddr.sin_port=htons(port);
	myaddr.sin_addr.s_addr=INADDR_ANY;

	/* Create the socket. */
	sockfd=net_create_udp_sock();
	if (sockfd<0) return(-1);

	/* Bind to our all IPs on our port. **/
	bind_ret=bind(sockfd, (struct sockaddr *) &myaddr, myaddrlen);
	if (bind_ret<0) {
		close(sockfd);
		return(-1);
	}

	return(sockfd);
}
#endif
