#ifndef _KE_LANBD_H_13Oct03
#define _KE_LANBD_H_13Oct03

#include "config.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <inttypes.h>

#define LANBD_VERSION "0.1.4"
#define LANBD_PORT 24200

/* XXX: document! */
#define LANBD_CLEANTIME (60*1000)  /* Cleanup time is 60s */

/* XXX: document! */
#define LANBD_PACKETSIZE (1300)

/*
 * XXX: Document!
 */
#ifdef LANBDD
#define LANBD_DEST INADDR_BROADCAST
#else
#define LANBD_DEST INADDR_LOOPBACK
#endif

#ifdef DEBUG
#define LANBD_RPORT_MAX 10240
#else
#define LANBD_RPORT_MAX 1029
#endif

typedef enum {
		WHOHAS=1,
		READ=2,
		WRITE=3,
		WHOHAS_R=WHOHAS|0x8,
		READ_R=READ|0x8,
		WRITE_R=WRITE|0x8
} cmd_t;

typedef enum {
	PFL_NONE=0,
	PFL_BROADCAST=1,
	PFL_ASYNC=2
} lanbd_packet_fl_t;

typedef enum {
	BFL_NONE=0,
	BFL_MASTER=1,
	BFL_CACHE=2,
	BFL_ANY=255
} lanbd_packet_bfl_t;

struct lanbd_packet {
	cmd_t cmd;
	uint16_t rport;
	uint32_t device;
	uint64_t block;

	lanbd_packet_bfl_t b_flags;   /* Only for WHOHAS/WHOHAS_R */
	uint32_t offset;              /* Only for READ/WRITE/READ_R/WRITE_R */
	uint32_t len;                 /* Only for READ/WRITE/READ_R/WRITE_R */
	uint64_t e_block;             /* Only for WHOHAS_R */
	uint8_t stat;                 /* Only for WRITE_R */
	void *data;                   /* Only for WRITE/READ_R */
	size_t datalen;               /* Used for integrity checking. */

	/* Socket source or destination. */
	struct sockaddr *addr;
	socklen_t addrlen;

	/* Only used for the daemon. */
	lanbd_packet_fl_t flags;
};


void *cmd_val2func(cmd_t cmd);
ssize_t lanbd_senddata(struct sockaddr *dest, socklen_t destlen, void *buf, size_t buflen, int async, cmd_t cmd, uint32_t device, uint64_t block, ...);
ssize_t lanbd_read(uint32_t device, uint64_t block, uint32_t offset, void *buf, size_t count);
ssize_t lanbd_write(uint32_t device, uint64_t block, uint32_t offset, void *buf, size_t count);

#endif
