#include "config.h"
#include <inttypes.h>


#if defined(_KE_DENDIAN_H) || !defined(_FAST)
#include "dendian.h"
#include "lanbd.h"

_KE_DENDIAN_RET uint64_t de_readbuf(const void *data, const int datalen) {
	uint64_t ret=0;
	unsigned char *real_data=(unsigned char *) data;
	signed int i=0;

	for (i=datalen-1; i>=0; i--) {
		ret<<=8;
		ret|=real_data[i];
	}

	return(ret);
}

_KE_DENDIAN_RET int de_writebuf(void *data, const uint64_t num, const int datalen) {
	unsigned char *ret=(unsigned char *) data;
	uint64_t real_num=num;
	int i=0;

	for (i=0; i<datalen; i++) {
		ret[i]=real_num&0xff;
		real_num>>=8;
	}

	return(0);
}

#endif
