#include <stdio.h>
#include <time.h>

#ifdef DEBUG
#define PRINT_LINE fprintf(stderr, "%lu:%s:%i:%s(): ", (unsigned long) time(NULL), __FILE__, __LINE__, __func__); 
#define PRINTERR(x...) { PRINT_LINE; fprintf(stderr, x); fprintf(stderr, "\n"); fflush(stderr); }
#define PERROR(x) { PRINT_LINE; perror(x); fflush(stderr); }
#define DPERROR(x) PERROR(x)
#define PRINTBUF(b, l) { int i=0; PRINT_LINE; fprintf(stderr, #b "[%i]:", l);; for (i=0; i<l; i++) { if ((i%30)==0) fprintf(stderr, "\n"); fprintf(stderr, "%02x ", (unsigned char) b[i]);  }; fprintf(stderr, "\n"); }
#else
#define PRINT_LINE /**/
#define PRINTERR(x...) /**/
#define PERROR(x) perror(x);
#define DPERROR(x) /**/
#define PRINTBUF(b, l) /**/
#endif
#define CHECKPOINT PRINTERR("*** CHECKPOINT REACHED ***")
#define SPOTVAR_LLX(x) PRINTERR(#x " = %llx", x)
#define SPOTVAR_LLU(x) PRINTERR(#x " = %llu", x)
#define SPOTVAR_LU(x) PRINTERR(#x " = %lu", x)
#define SPOTVAR_D(x) PRINTERR(#x " = %lf", x)
#define SPOTVAR_X(x) PRINTERR(#x " = 0x%x", x)
#define SPOTVAR_I(x) PRINTERR(#x " = %i", x)
#define SPOTVAR_P(x) PRINTERR(#x " = %p", x)
#define SPOTVAR_S(x) PRINTERR(#x " = \"%s\"", x)
#define PRINTERR_X(x...) { PRINT_LINE; fprintf(stderr, x); fprintf(stderr, "\n"); fflush(stderr); }

#if (DEBUG>=3)
#define DBG_ENTER(x, y...) PRINTERR("Called as: %s(" x ")", __func__, y);
#else
#define DBG_ENTER(x, y...) /**/
#endif

#define LOG(x...) { fprintf(stderr, "LOG: " x); fprintf(stderr, "\n"); }
