	"proc tclInit {} {\n"
	"	rename tclInit {}\n"
	"\n"
	"	global auto_path tcl_library tcl_libPath\n"
	"	global tcl_version tcl_rcFileName\n"
	"  \n"
	"	set mountpoint [subst \"$::TCLKIT_MOUNTPOINT_VAR\"]\n"
	"\n"
	"	# Resolve symlinks\n"
	"	set mountpoint [file dirname [file normalize [file join $mountpoint __dummy__]]]\n"
	"\n"
	"	set tcl_library [file join $mountpoint lib tcl$tcl_version]\n"
	"	set tcl_libPath [list $tcl_library [file join $mountpoint lib]]\n"
	"\n"
	"	# the following code only gets executed once on startup\n"
	"	if {[info exists ::TCLKIT_INITVFS]} {\n"
	"		# lookup and emulate \"source\" of lib/vfs/{vfs*.tcl,mk4vfs.tcl}\n"
	"		switch -- $::tclKitStorage {\n"
	"			\"mk4\" {\n"
	"				# must use raw MetaKit calls because VFS is not yet in place\n"
	"				set d [mk::select exe.dirs parent 0 name lib]\n"
	"				set d [mk::select exe.dirs parent $d name vfs]\n"
	"    \n"
	"				foreach x {vfsUtils vfslib mk4vfs} {\n"
	"					set n [mk::select exe.dirs!$d.files name $x.tcl]\n"
	"					set s [mk::get exe.dirs!$d.files!$n contents]\n"
	"					catch {set s [zlib decompress $s]}\n"
	"					uplevel #0 $s\n"
	"				}\n"
	"\n"
	"				# use on-the-fly decompression, if mk4vfs understands that\n"
	"				set mk4vfs::zstreamed 1\n"
	"\n"
	"				# Set VFS handler name\n"
	"				set vfsHandler [list ::vfs::mk4::handler exe]\n"
	"			}\n"
	"			\"zip\" {\n"
	"				set prefix \"lib/vfs\"\n"
	"				foreach file [list vfsUtils vfslib] {\n"
	"					set fullfile \"${prefix}/${file}.tcl\"\n"
	"\n"
	"					::zip::stat $::tclKitStorage_fd $fullfile finfo\n"
	"					seek $::tclKitStorage_fd $finfo(ino)\n"
	"					zip::Data $::tclKitStorage_fd sb s\n"
	"\n"
	"					switch -- $file {\n"
	"						\"vfsUtils\" {\n"
	"							# Preserve our working \"::vfs::zip\" implementation\n"
	"							# so we can replace it after the stub is replaced\n"
	"							# from vfsUtils\n"
	"							# The correct implementation will be provided by vfslib, \n"
	"							# but only if we can read it\n"
	"							rename ::vfs::zip ::vfs::zip_impl\n"
	"						}\n"
	"					}\n"
	"\n"
	"					uplevel #0 $s\n"
	"\n"
	"					switch -- $file {\n"
	"						\"vfsUtils\" {\n"
	"							# Restore preserved \"::vfs:zip\" implementation\n"
	"							rename ::vfs::zip {}\n"
	"							rename ::vfs::zip_impl ::vfs::zip\n"
	"						}\n"
	"					}\n"
	"				}\n"
	"\n"
	"				seek $::tclKitStorage_fd 0\n"
	"				set vfsHandler [list ::vfs::zip::handler $::tclKitStorage_fd]\n"
	"				unset ::tclKitStorage_fd\n"
	"			}\n"
	"			\"cvfs\" {\n"
	"				set vfsHandler [list ::vfs::cvfs::vfshandler tcl]\n"
	"\n"
	"				# Load these, the original Tclkit does so it should be safe.\n"
	"				foreach vfsfile [list vfsUtils vfslib] {\n"
	"					unset -nocomplain s\n"
	"\n"
	"					catch {\n"
	"						set s [::vfs::cvfs::data::getData tcl \"lib/vfs/${vfsfile}.tcl\"]\n"
	"					}\n"
	"\n"
	"					if {![info exists s]} {\n"
	"						continue\n"
	"					}\n"
	"\n"
	"					uplevel #0 $s\n"
	"				}\n"
	"			}\n"
	"		}\n"
	"\n"
	"		# mount the executable, i.e. make all runtime files available\n"
	"		vfs::filesystem mount $mountpoint $vfsHandler\n"
	"\n"
	"		# alter path to find encodings\n"
	"		if {[info tclversion] eq \"8.4\"} {\n"
	"			load {} pwb\n"
	"			librarypath [info library]\n"
	"		} else {\n"
	"			encoding dirs [list [file join [info library] encoding]] ;# TIP 258\n"
	"		}\n"
	"\n"
	"		# fix system encoding, if it wasn't properly set up (200207.004 bug)\n"
	"		if {[encoding system] eq \"identity\"} {\n"
	"			if {[info exists ::tclkit_system_encoding] && $::tclkit_system_encoding != \"\"} {\n"
	"				catch {\n"
	"					encoding system $::tclkit_system_encoding\n"
	"				}\n"
	"			}\n"
	"		}\n"
	"\n"
	"		# If we've still not been able to set the encoding, revert to Tclkit defaults\n"
	"		if {[encoding system] eq \"identity\"} {\n"
	"			catch {\n"
	"				switch $::tcl_platform(platform) {\n"
	"					windows		{ encoding system cp1252 }\n"
	"					macintosh	{ encoding system macRoman }\n"
	"				        default		{ encoding system iso8859-1 }\n"
	"				}\n"
	"			}\n"
	"		}\n"
	"\n"
	"		# Re-evaluate mountpoint with correct encoding set\n"
	"		set mountpoint [subst \"$::TCLKIT_MOUNTPOINT_VAR\"]\n"
	"\n"
	"		# now remount the executable with the correct encoding\n"
	"		vfs::filesystem unmount [lindex [::vfs::filesystem info] 0]\n"
	"\n"
	"		# Resolve symlinks\n"
	"		set mountpoint [file dirname [file normalize [file join $mountpoint __dummy__]]]\n"
	"\n"
	"		set tcl_library [file join $mountpoint lib tcl$tcl_version]\n"
	"		set tcl_libPath [list $tcl_library [file join $mountpoint lib]]\n"
	"\n"
	"		vfs::filesystem mount $mountpoint $vfsHandler\n"
	"\n"
	"		# This loads everything needed for \"clock scan\" to work\n"
	"		# \"clock scan\" is used within \"vfs::zip\", which may be\n"
	"		# loaded before this is run causing the root VFS to break\n"
	"		catch { clock scan }\n"
	"	}\n"
	"  \n"
	"	# load config settings file if present\n"
	"	namespace eval ::vfs { variable tclkit_version 1 }\n"
	"	catch { uplevel #0 [list source [file join $mountpoint config.tcl]] }\n"
	"\n"
	"	# Set-up starkit::tclkitroot\n"
	"	namespace eval ::starkit { variable tclkitroot }\n"
	"	set ::starkit::tclkitroot $mountpoint\n"
	"\n"
	"	# Perform expected initialization\n"
	"	uplevel #0 [list source [file join $tcl_library init.tcl]]\n"
	"  \n"
	"	# reset auto_path, so that init.tcl's search outside of tclkit is cancelled\n"
	"	set auto_path $tcl_libPath\n"
	"\n"
	"	if {$::TCLKIT_TYPE == \"kitdll\"} {\n"
	"		# Set a maximum seek to avoid reading the entire file looking for a\n"
	"		# zip header\n"
	"		catch { \n"
	"			package require vfs::zip\n"
	"			set ::zip::max_header_seek 8192\n"
	"		}\n"
	"\n"
	"		# Now that the initialization is complete, mount the user VFS if needed\n"
	"		## Mount the VFS from the Shared Object\n"
	"		if {[info exists ::TCLKIT_INITVFS] && [info exists ::tclKitFilename]} {\n"
	"			catch {\n"
	"				vfs::zip::Mount $::tclKitFilename \"/.KITDLL_USER\"\n"
	"			}\n"
	"		}\n"
	"		lappend auto_path \"/.KITDLL_USER/lib\"\n"
	"\n"
	"		## Mount the VFS from executable\n"
	"		if {[info exists ::TCLKIT_INITVFS]} {\n"
	"			catch {\n"
	"				vfs::zip::Mount [info nameofexecutable] \"/.KITDLL_APP\"\n"
	"			}\n"
	"		}\n"
	"		lappend auto_path \"/.KITDLL_APP/lib\"\n"
	"	}\n"
	"\n"
	"	# Clean up\n"
	"	unset -nocomplain ::zip::max_header_seek\n"
	"	unset -nocomplain ::TCLKIT_TYPE ::TCLKIT_INITVFS\n"
	"	unset -nocomplain ::TCLKIT_MOUNTPOINT ::TCLKIT_VFSSOURCE ::TCLKIT_MOUNTPOINT_VAR ::TCLKIT_VFSSOURCE_VAR\n"
	"	unset -nocomplain ::tclKitStorage ::tclKitStorage_fd ::tclKitFilename\n"
	"	unset -nocomplain ::tclkit_system_encoding\n"
	"}\n"
