/*
    fifos.h -- Common definitions for fifos.
    Copyright (C) 2003  Roy Keene

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	email: fifos@rkeene.org

*/
#ifndef FIFOS_H_313
#define FIFOS_H_313
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>

#ifdef EBUG
#define DEBUG EBUG
#endif

#ifdef DEBUG
#define PRINT_LINE fprintf(stderr, "%s:%i:%s(): ", __FILE__, __LINE__, __func__); 
#define PRINTERR(x...) { PRINT_LINE; fprintf(stderr, x); fprintf(stderr, "\n"); fflush(stderr); }
#define PERROR(x) { PRINT_LINE; perror(x); fflush(stderr); }
#define DPERROR(x) PERROR(x)
#define CHECKPOINT PRINTERR("*** CHECKPOINT REACHED ***")
#else
#define PRINT_LINE /**/
#define PRINTERR(x...) /**/
#define PERROR(x) perror(x);
#define DPERROR(x) /**/
#define CHECKPOINT /**/
#endif
#define SPOTVAR_D(x) PRINTERR(#x " = %lf", x)
#define SPOTVAR_I(x) PRINTERR(#x " = %i", x)
#define SPOTVAR_S(x) PRINTERR(#x " = %s", x)
#define PRINTERR_X(x...) { PRINT_LINE; fprintf(stderr, x); fprintf(stderr, "\n"); fflush(stderr); }

#define FIFOS_VERSION "0.0.1"

#endif
