#ifndef _DIRECTSHARE_H
#define _DIRECTSHARE_H

#define DIRECTSHARE_VER_MAJ 0
#define DIRECTSHARE_VER_MIN 0
#define DIRECTSHARE_VER_REV 1
#define DIRECTSHARE_VER_INFO "dev"

#ifndef DIRECTSHARE_TCP_PORT
#define DIRECTSHARE_TCP_PORT 3903
#endif



#ifdef DEBUG
#define PERROR(x) { fprintf(stderr, __FILE__ ":%04i: ", __LINE__); perror(x); }
#define PRINTERR(x...) { fprintf(stderr, __FILE__ ":%04i: ", __LINE__); fprintf(stderr, x); fprintf(stderr, "\n"); }
#define PRT(x) PRINTERR(#x "=%i", x);
#define PRTS(x) PRINTERR(#x "=%s", x);
#else
#define PERROR(x)      /*  */
#define PRINTERR(x...) /*  */
#define PRT(x)         /*  */
#define PRTS(x)        /*  */
#endif


#define DIRECTSHARE_ERROR (-1)
#define DIRECTSHARE_OK    (0)


#define DS_CMD_HELO 0x4f4c4548
#define DS_CMD_FILE 0x454c4946
#define DS_CMD_SERV 0x56524553
#define DS_CMD_ADDR 0x52444441
#define DS_CMD_EROR 0x524f5245
#define DS_CMD_OKAY 0x59414b4f
#define DS_CMD_QUIT 0x54495551

#define DS_RET_QUIT 0

#define DIRECTSHARE_TYPE_SERV	0
#define DIRECTSHARE_TYPE_CLNT	1
#define DIRECTSHARE_TYPE_UNKNOWN	2

#define DIRECTSHARE_BUF_SIZE	4096

struct directshare_connstat {
	unsigned long state; /* DIRECTSHARE_CMD_XXXX */
	unsigned char type;  /* Server, Client Node DIRECTSHARE_TYPE_XXXXXX */
	unsigned int bufsize; /* Size of buffer. */
	unsigned int buflen; /* Used portion of buffer. */
	char *buf;           /* Used to buffer */
	char host[16];       /* Hostname */
	int ignore;          /* Ignore bytes of data */
};

struct directshare_cmdinfo {
	unsigned long hash;        /* 32bit hash */
	int (*func)();             /* Handler for this command */
	unsigned char propagate;   /* Send this command to all hubs ? */
	unsigned char routeable;   /* Is this message routeable ? */
};


void ds_shutdown(void);
void ds_sighandler(int sig);
void ds_handledata(int sock_fd, char *data, int datalen);
void ds_init(int sock_fd, char *host);
void ds_handleclose(int sock_fd);
int ds_cmd_helo(int sock_fd, struct directshare_connstat *sinfo, int argc, char **argv);
int ds_cmd_serv(int sock_fd, struct directshare_connstat *sinfo, int argc, char **argv);
int ds_cmd_addr(int sock_fd, struct directshare_connstat *sinfo, int argc, char **argv);
int ds_cmd_file(int sock_fd, struct directshare_connstat *sinfo, int argc, char **argv);
int ds_cmd_okay(int sock_fd, struct directshare_connstat *sinfo, int argc, char **argv);
int ds_cmd_quit(int sock_fd, struct directshare_connstat *sinfo, int argc, char **argv);


#define ds_printf(sock, x...) { char buf[1024]; snprintf(buf, 1023, x); write(sock, buf, strlen(buf)); }

#endif
