/*
 * Copyright (C) 2001  Roy Keene
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *      email: dact@rkeene.org
 */


#include "module.h"
#ifdef HAVE_LIBDL
#include <dlfcn.h>
#include <stdio.h>
#include <string.h>
#include "dact.h"
#include "algorithms.h"

char moduledirectory[128] = ".";
void *modules[256];
int modules_initialized = 0;
int modules_count = 0;

int init_modules (void) {
	int i;

	if (modules_initialized!=0) return(DACT_MOD_FAIL);
	modules_initialized=1;

	for (i=0;i<256;i++) {
		modules[i]=NULL;
	}
	return(DACT_MOD_OK);
}

int unload_modules (void) {
	int i;

	if (modules_initialized==0) return(DACT_MOD_FAIL);

	for (i=0;i<256;i++) {
		if (modules[i]!=NULL)
			dlclose(modules[i]);
	}
	return(DACT_MOD_OK);
}

int load_module (char *modulename) {
	char modulefile[256];
	void *mh;
	int algo_num;
	int i,eof=0;

	snprintf(modulefile, sizeof(modulefile)-1, "%s/%s.so",moduledirectory,modulename);

	if ((mh=dlopen(modulefile, RTLD_LAZY))==NULL) {
		printf("%s load failure.\n", modulefile);
		return(DACT_MOD_FAIL);
	}

	if (dlsym(mh,"DC_NUM")==NULL \
	|| dlsym(mh, "DC_NAME")==NULL \
	|| dlsym(mh, "DC_ALGO")==NULL) {
		printf("%s is not a dact module.\n", modulefile);
		dlclose(mh);
		return(DACT_MOD_FAIL);
	}

	memcpy(&algo_num,dlsym(mh,"DC_NUM"),sizeof(algo_num));

	if (algorithms[algo_num]!=DACT_FAILED_ALGO && algorithms[algo_num]!=NULL) {
		printf("Something is already handling algorithm %i.\n",algo_num);
		dlclose(mh);
		return(DACT_MOD_FAIL);
	}

	memcpy(&algorithms[algo_num],dlsym(mh, "DC_ALGO"),sizeof(algorithms[0]));
	memcpy(&algorithm_names[algo_num],dlsym(mh,"DC_NAME"),sizeof(algorithm_names[0]));

	modules[algo_num]=mh;

	if (algo_num>modules_count) {
		for (i=0;i<algo_num;i++) {
			if (algorithms[i]==NULL) eof=1;
			if (eof==1) algorithms[i]=DACT_FAILED_ALGO;
		}
		if (eof==1) algorithms[algo_num+1]=NULL;
		modules_count=algo_num;
	}

	return(DACT_MOD_OK);
}
#else
char moduledirectory[128] = ".";
void *modules[256];
int modules_initialized = 0;
int modules_count = 0;

int init_modules (void) { return(DACT_MOD_FAIL); }
int unload_modules (void) { return(DACT_MOD_FAIL); }
int load_module (char *modulename) { return(DACT_MOD_FAIL); }



#endif
