/*
 * Copyright (C) 2001  Roy Keene
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *      email: dact@rkeene.org
 */


/*
	Example block compression routine for interfacing with DACT.

	Uses zlib.
*/


#include "dact.h"
#include "comp_zlib.h"
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <zlib.h>


/*
	mode 		- DACT_MODE_COMPR or DACT_MODE_DECMP
			    Determine whether to compress or decompress.
	prev_block	- Previous (uncompressed) block.
	curr_block	- The data to be compressed.
	out_block	- Where to put data after compression.
	blk_size	- Size of prev_block and curr_block.
*/

#if defined(USE_MODULES) && defined(AS_MODULE)
int DC_NUM=4;
void *DC_ALGO=comp_zlib_algo;
char *DC_NAME="Zlib Compression (MOD)";
#endif

int comp_zlib_algo(int mode, unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	switch(mode) {
		case DACT_MODE_COMPR:
			return(comp_zlib_compress(prev_block,curr_block,out_block,blk_size));
			break; /* Heh */
		case DACT_MODE_DECMP:
			return(comp_zlib_decompress(prev_block,curr_block,out_block,blk_size));
			break;
		default:
			printf("Unsupported mode: %i\n", mode);
			return(-1);
	}
}

int comp_zlib_compress(unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	unsigned long dest_size;
	int retval;
	dest_size=(int) ((float) (blk_size*1.01)+13);

#ifdef HAVE_COMPRESS2
	retval=compress2(out_block, &dest_size, curr_block, blk_size, Z_BEST_COMPRESSION);
#else
	retval=compress(out_block, &dest_size, curr_block, blk_size);
#endif
	if (retval!=Z_OK) return(-1);

	return(dest_size);
}

int comp_zlib_decompress(unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	unsigned long dest_size;
	int retval;

	dest_size=(DACT_BLK_SIZE*2);
	retval=uncompress(out_block,&dest_size,curr_block,blk_size);


	if (retval!=Z_OK) {
		return(0);
	}
	return(dest_size);
}
