#ifndef _CIPHER_SUB_H
#define _CIPHER_SUB_H
#include "dact.h"

int cipher_sub(const char *inblock, char *outblock, const int blksize, char *key, const int mode);
int cipher_sub_init(const int mode, char *key);
int cipher_sub_init_getkey(const int mode, char *key);
int cipher_sub_encrypt(const char *inblk, char *outblk, int blksize, char *key);
int cipher_sub_decrypt(const char *inblk, char *outblk, int blksize, char *key);
char *cryptdata(unsigned char key[256], const unsigned char *data, int size);
char *decryptdata(unsigned char key[256], const unsigned char *data, int size);
char *generatekey(void);

#ifdef HAVE_DEV_URANDOM
#define RANDOM_DEV "/dev/urandom"
#endif
#endif
