/*
	Encrypt data.
*/
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#ifndef RANDOM_DEV
#include <time.h>
#endif
#include "cipher_sub.h"
#include "dact.h"
#include "ui.h"



int cipher_sub(const char *inblock, char *outblock, const int blksize, char *key, const int mode) {
	switch (mode) {
		case (DACT_MODE_CINIT+DACT_MODE_CDEC):
		case (DACT_MODE_CINIT+DACT_MODE_CENC):
		case DACT_MODE_CINIT:
			return(cipher_sub_init(mode,key));
			break;
		case DACT_MODE_CDEC:
			return(cipher_sub_encrypt(inblock, outblock, blksize, key));
			break;
		case DACT_MODE_CENC:
			return(cipher_sub_decrypt(inblock, outblock, blksize, key));
			break;
	}
	return(0);
}


int cipher_sub_init(const int mode, char *key) {
	return(cipher_sub_init_getkey(mode-DACT_MODE_CINIT,key));
}

int cipher_sub_init_getkey(const int mode, char *key) {
	char *fname;
	int fd;

	fname=dact_ui_getuserinput("Key file: ",128,0);
	if (mode==DACT_MODE_CDEC) {
		fd=open(fname, O_RDONLY);
		read(fd, key, 256);
		close(fd);
		return(256);
	}
	if (mode==DACT_MODE_CENC) {
		fd=open(fname, O_WRONLY|O_CREAT|O_TRUNC, 0600);
		key=generatekey();
		write(fd, key, 256);
		close(fd);
		return(256);
	}
	return(-1);
}

int cipher_sub_encrypt(const char *inblk, char *outblk, int blksize, char *key) {
	memcpy(outblk,cryptdata(key,inblk,blksize),blksize);
	return(blksize);
}

int cipher_sub_decrypt(const char *inblk, char *outblk, int blksize, char *key) {
	memcpy(outblk,decryptdata(key,inblk,blksize),blksize);
	return(blksize);
}

char *cryptdata(unsigned char key[256], const unsigned char *data, int size) {
	int i;
	static char *result;
        result=malloc(size);
	for (i=0;i<size;i++) {
		result[i]=key[(int) data[i]];
	}
	return(result);
}

char *decryptdata(unsigned char key[256], const unsigned char *data, int size) {
	int i;
	char reversekey[256];
	static char *result;
	result=malloc(size);
	for (i=0;i<256;i++) reversekey[(int) key[i]]=i;
	for (i=0;i<size;i++) {
		result[i]=reversekey[(int) data[i]];
	}
	return(result);
}

char *generatekey(void) {
	static char key[256];
	char used[256];
	int i,x;
#ifdef RANDOM_DEV
	unsigned char buff[1];
	int fd;
	fd=open(RANDOM_DEV, O_RDONLY);
#endif
	for (i=0;i<256;i++) used[i]=0;
	for (i=0;i<256;i++) {
#ifdef RANDOM_DEV
		read(fd, buff, 1);
		x=buff[0];
#else
		srand(time(NULL)%rand());
		x=1+(int) (255.0*rand()/(RAND_MAX+1.0));
#endif
		if (used[x]==0) { key[i]=x; used[x]=1; } else { i--; }
	}
#ifdef RANDOM_DEV
	close(fd);
#endif
	return(key);
}
