/*
	Insert GPL Here.
*/

#define _MODULE_C
#include "module.h"
#ifdef USE_MODULES
#include <dlfcn.h>
#include <stdio.h>
#include "dact.h"
#include "algorithms.h"

int init_modules (void) {
	int i;

	if (modules_initialized!=0) return(DACT_MOD_FAIL);
	modules_initialized=1;

	for (i=0;i<256;i++) {
		modules[i]=NULL;
	}
	return(DACT_MOD_OK);
}

int unload_modules (void) {
	int i;
	for (i=0;i<256;i++) {
		if (modules[i]!=NULL)
			dlclose(modules[i]);
	}
	return(DACT_MOD_OK);
}

int load_module (char *modulename) {
	char modulefile[256];
	void *mh;
	int algo_num;
	int i,eof=0;

	snprintf(modulefile, sizeof(modulefile)-1, "%s/%s.so",moduledirectory,modulename);

	if ((mh=dlopen(modulefile, RTLD_LAZY))==NULL) {
		return(DACT_MOD_FAIL);
	}

	if (dlsym(mh,"DC_NUM")==NULL \
	|| dlsym(mh, "DC_NAME")==NULL \
	|| dlsym(mh, "DC_ALGO")==NULL) {
		dlclose(mh);
		return(DACT_MOD_FAIL);
	}

	memcpy(&algo_num,dlsym(mh,"DC_NUM"),sizeof(algo_num));

// TODO: Make this not check something stupid like !=NULL, but instead verify
// by count.
	if (algorithms[algo_num]!=DACT_FAILED_ALGO && algorithms[algo_num]!=NULL) {
		printf("Something is already handling algorithm %i.\n",algo_num);
		dlclose(mh);
		return(DACT_MOD_FAIL);
	}

	memcpy(&algorithms[algo_num],dlsym(mh, "DC_ALGO"),sizeof(algorithms[0]));
	memcpy(&algorithm_names[algo_num],dlsym(mh,"DC_NAME"),sizeof(algorithm_names[0]));

	modules[algo_num]=mh;

	if (algo_num>modules_count) {
		for (i=0;i<algo_num;i++) {
			if (algorithms[i]==NULL) eof=1;
			if (eof==1) algorithms[i]=DACT_FAILED_ALGO;
		}
		if (eof==1) algorithms[algo_num+1]=NULL;
		modules_count=algo_num;
	}

	return(DACT_MOD_OK);
}
#endif
