/*
	Algorithms!
*/

#include "comp_plain.h"
#include "comp_rle.h"
#include "comp_delta.h"
#ifdef USE_ZLIB
#include "comp_zlib.h"
#include "comp_mzlib.h"
#include "comp_mzlib2.h"
#endif
#ifdef USE_BZLIB
#include "comp_bzlib.h"
#endif
#ifdef DEBUG
#include "comp_factor.h"
#endif
#include "comp_range.h"
#include "comp_snibble.h"
#include "comp_text.h"
#include "comp_fail.h"

#ifdef __DACT_C
int (*(algorithms[256]))()={    comp_plain_algo,
                                comp_rle_algo,
                                comp_delta_algo,
				comp_text_algo,
#ifdef USE_ZLIB
				comp_zlib_algo,
				comp_mzlib_algo,
#else
				DACT_FAILED_ALGO,
				DACT_FAILED_ALGO,
#endif
				comp_snibble_algo,
				comp_range_algo,
#ifdef USE_ZLIB
				comp_mzlib2_algo,
#else
				DACT_FAILED_ALGO,
#endif
#ifdef USE_BZLIB
				comp_bzlib_algo,
#else
				DACT_FAILED_ALGO,
#endif
#ifdef DEBUG
				comp_factor_algo,
#else
				DACT_FAILED_ALGO,
#endif
                                NULL};

char *algorithm_names[256]={	"Uncompressed",
				"RLE Compression",
				"Delta Compression",
				"Text Compression",
#ifdef USE_ZLIB
				"Zlib Compression",
				"Modified Zlib Compression",
#else
				"Unsupported Algorithm (zlib)",
				"Unsupported Algorithm (mzlib)",
#endif
				"Seminibble Encoding",
				"Range Encoding",
#ifdef USE_ZLIB
				"Second Modified Zlib Compression",
#else
				"Unsupported Algorithm (mzlib2)",
#endif
#ifdef USE_BZLIB
				"Bzip2 Compression",
#else
				"Unsupported Algorithm (bzlib)",
#endif
#ifdef DEBUG
				"Factor Compression",
#else
				"Unsupported Algorithm (factor)",
#endif
				NULL
			};
#else
extern int (*(algorithms[256]))();
extern char *algorithm_names[256];
#endif
