#!/bin/sh

MACHINE=`uname -m | sed s/"i.86"/"i386"/ | dd conv=lcase 2>/dev/null`
OS=`uname -s | dd conv=lcase 2>/dev/null`
FILE="http://keene.netfueldesign.com/devel/dact/precompiled/dact-$MACHINE-$OS.bin"
LFILE="dact-$MACHINE-$OS"



if which lynx 2>/dev/null >/dev/null; then
  lynx -nostatus -dump $FILE > $LFILE 2>/dev/null
elif which wget 2>/dev/null >/dev/null; then
  wget -q $FILE 2>/dev/null >/dev/null
else
  echo "No appropriate way to download."
  echo "The file is at:"
  echo "$FILE"
  exit 1
fi

if [ -e $LFILE ]; then
 if head -2 $LFILE | grep "Not Found" 2>/dev/null >/dev/null; then
   rm $LFILE
 fi 
fi

if [ ! -e $LFILE ]; then
  echo "Unable to find an appropriate precompiled binary for a $MACHINE running $OS"
  echo "Contact Roy Keene <rkeene@netfueldesign.com> if you need further assistance."
  echo "The latest dact source can be found at:"
  echo "http://keene.netfueldesign.com/devel/dact.tar.gz"
  exit 1
fi

chmod 0755 $LFILE

ID=`id | cut -f 2 -d = | cut -f 1 -d "("`
if [ $ID = 0 ]; then
  cp $LFILE /usr/local/bin
  cat /usr/local/bin/dact > /usr/local/bin/dact.old 2>/dev/null
  rm -f /usr/local/bin/dact
  ln -s /usr/local/bin/$LFILE /usr/local/bin/dact
  chown root /usr/local/bin/dact.old /usr/local/bin/$LFILE
  chgrp root /usr/local/bin/dact.old /usr/local/bin/$LFILE
  chmod 0755  /usr/local/bin/dact.old /usr/local/bin/$LFILE
else
  mkdir $HOME/.dact/ 2>/dev/null >/dev/null
  cp $LFILE $HOME/.dact/dact.bin
fi

rm $LFILE
