#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "dact.h"
#include "dendian.h"

int write_de(const int dst, const uint32_t num, const int sze) {
	unsigned char buf[4]={0, 0, 0, 0};
	int i,x=0,v;

	for (i=0;i<sze;i++) {
		buf[sze-i-1]=((num&(0xff<<(i*8)))>>(i*8));
	}

	for (i=0;i<sze;i++) {
		if ((v=write(dst, &buf[i], 1))<0) {
			PERROR("write");
			return(-1);
		}
		x+=v;
	}


	return(x);
}

int read_de(const int src, void *dest, const int sze) {
	unsigned char ch;
	uint32_t ret=0;
	int i;

	for (i=0;i<sze;i++) {
		if (read(src, &ch, 1)<1) {
			PERROR("read");
			return(-1);
		}
		ret|=ch<<(8*(sze-i-1));
	}

	memcpy(dest, &ret, sze);
	return(sze);
}
