/*
 * Copyright (C) 2000  Roy Keene
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *      email: rkeene@netfueldesign.com
 */


#include "dact.h"
#include "comp_bzlib.h"
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <bzlib.h>


/*
	mode 		- DACT_MODE_COMPR or DACT_MODE_DECMP
			    Determine whether to compress or decompress.
	prev_block	- Previous (uncompressed) block.
	curr_block	- The data to be compressed.
	out_block	- Where to put data after compression.
	blk_size	- Size of prev_block and curr_block.
*/
int comp_bzlib_algo(int mode, unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	switch(mode) {
		case DACT_MODE_COMPR:
			return(comp_bzlib_compress(prev_block,curr_block,out_block,blk_size));
			break; /* Heh */
		case DACT_MODE_DECMP:
			return(comp_bzlib_decompress(prev_block,curr_block,out_block,blk_size));
			break;
		default:
			fprintf(stderr, "Unsupported mode: %i\n", mode);
			return(-1);
	}
}

int comp_bzlib_compress(unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	unsigned int dest_size=(DACT_BLK_SIZE*2);
	int retval;

	retval=bzBuffToBuffCompress(out_block, &dest_size, curr_block, blk_size, 1, 0, 9);
	if (retval!=BZ_OK) return(-1);

	return(dest_size);
}

int comp_bzlib_decompress(unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	unsigned int dest_size=(DACT_BLK_SIZE*2);
	int retval;

	retval=bzBuffToBuffDecompress(out_block, &dest_size, curr_block, blk_size, 0, 0);

	if (retval!=BZ_OK) return(0);
	return(dest_size);
}
