
#ifndef __ENDIAN_LOCAL_H
#define __ENDIAN_LOCAL_H

unsigned char ENDIAN_LOCAL_BUF[4]={0, 0, 0, 0};

#define WRITE_2BYTE_DE(x,y) 2; \
			ENDIAN_LOCAL_BUF[0]=((y&0xff00) >> 8); \
			ENDIAN_LOCAL_BUF[1]=((y&0x00ff)); \
			write(x,&ENDIAN_LOCAL_BUF[0],1); \
			write(x,&ENDIAN_LOCAL_BUF[1],1)

#define WRITE_4BYTE_DE(x,y) 4; \
			ENDIAN_LOCAL_BUF[0]=((y&0xff000000) >> 24); \
			ENDIAN_LOCAL_BUF[1]=((y&0x00ff0000) >> 16); \
			ENDIAN_LOCAL_BUF[2]=((y&0x0000ff00) >> 8); \
			ENDIAN_LOCAL_BUF[3]=((y&0x000000ff)); \
			write(x,&ENDIAN_LOCAL_BUF[0],1); \
			write(x,&ENDIAN_LOCAL_BUF[1],1); \
			write(x,&ENDIAN_LOCAL_BUF[2],1); \
			write(x,&ENDIAN_LOCAL_BUF[3],1)

#define READ_2BYTE_DE(x,y) (read(x,&ENDIAN_LOCAL_BUF[0],1)+ \
			    read(x,&ENDIAN_LOCAL_BUF[1],1)); \
			y=((ENDIAN_LOCAL_BUF[0]<<8)|ENDIAN_LOCAL_BUF[1])

#define READ_4BYTE_DE(x,y) (read(x,&ENDIAN_LOCAL_BUF[0],1)+\
			    read(x,&ENDIAN_LOCAL_BUF[1],1)+\
			    read(x,&ENDIAN_LOCAL_BUF[2],1)+\
			    read(x,&ENDIAN_LOCAL_BUF[3],1)); \
			y=((ENDIAN_LOCAL_BUF[0]<<24)|(ENDIAN_LOCAL_BUF[1]<<16)|(ENDIAN_LOCAL_BUF[2]<<8)|ENDIAN_LOCAL_BUF[3])
#endif
