#ifndef _RSA_MD4_H
#define _RSA_MD4_H 1

/* MD4.H - header file for MD4C.C
 */

/* Copyright (C) 1991-2, RSA Data Security, Inc. Created 1991. All
   rights reserved.

   License to copy and use this software is granted provided that it
   is identified as the "RSA Data Security, Inc. MD4 Message-Digest
   Algorithm" in all material mentioning or referencing this software
   or this function.

   License is also granted to make and use derivative works provided
   that such works are identified as "derived from the RSA Data
   Security, Inc. MD4 Message-Digest Algorithm" in all material
   mentioning or referencing the derived work.

   RSA Data Security, Inc. makes no representations concerning either
   the merchantability of this software or the suitability of this
   software for any particular purpose. It is provided "as is"
   without express or implied warranty of any kind.

   These notices must be retained in any copies of any part of this
   documentation and/or software.
 */

#include "compat.h"

/* MD4 context. */
typedef struct {
  uint32_t state[4];    /* state (ABCD) */
  uint32_t count[2];    /* number of bits, modulo 2^64 (lsb first) */
  unsigned char buffer[64];                         /* input buffer */
} rsaref_MD4_CTX;

void rsaref_MD4Init(rsaref_MD4_CTX *);
void rsaref_MD4Update(rsaref_MD4_CTX *, unsigned char *, unsigned int);
void rsaref_MD4Final(unsigned char [16], rsaref_MD4_CTX *);

#endif
