#ifndef _LIBBACKUPPCD_H
#define _LIBBACKUPPCD_H 1
/*
 * Copyright (C) 2005  Roy Keene
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Author Information
 *      Roy Keene
 *      Planning Systems Inc
 *      Slidell, LA
 *      backuppcd-bugs@psislidell.com
 */

#include <unistd.h>
#include <backuppcd.h>

/*
 * These define symbols to determine whether or not write() or send() should
 * be used to transfer data to a descriptor.  write() may not be usable on
 * socket descriptors, and send() will never work for file descriptors.
 */
typedef enum {
	BPC_MODE_WRITE,
	BPC_MODE_SEND
} bpc_mode_t;

/*
 * This structure is used to give access to file information from a GET or
 * LIST operation.
 */
struct bpc_fileinfo {
	backuppc_filetype_t type;
	unsigned long long size;
	char owner_group[BPC_MAXPATH_LEN];
	char owner_user[BPC_MAXPATH_LEN];
	char linkdest[BPC_MAXPATH_LEN];
	char name[BPC_MAXPATH_LEN];
	unsigned char hash_md4[16];
	unsigned char hash_md5[16];
	unsigned char hash_bpc[16];
	unsigned char hash_sha1[20];
	long dev_major;
	long dev_minor;
	long uid;
	long gid;
	time_t mtime;
	time_t ctime;
	int mode;
};

/*
 * The BPC_CONN type is used as a handle to represent an individual connection
 * a BackupPCd Server.
 */
typedef struct bpc_conn BPC_CONN;

/*
 * LibBackupPCd API
 */

/*
 * Operations associated with connection management
 */
BPC_CONN *bpc_connect(const char *host, const int port, const char *username, const char *password);
int bpc_disconnect(BPC_CONN *handle);

/*
 * Operations associated with authentication
 */
int bpc_auth(BPC_CONN *handle, const char *username, const char *password);

/*
 * Operations associated with getting a listing of files
 */
int bpc_list_open(BPC_CONN *handle, const char *rootpath, const int recursive, backuppc_hashid_t hashalgo, const char *exclpat, const char *inclpat);
struct bpc_fileinfo *bpc_list(BPC_CONN *handle);
int bpc_list_close(BPC_CONN *handle);

/*
 * Operations associated with transfering files
 */
int bpc_get_open(BPC_CONN *handle, const char *rootpath, const int recursive, backuppc_hashid_t hashalgo, const char *exclpat, const char *inclpat);
struct bpc_fileinfo *bpc_get_head(BPC_CONN *handle);
ssize_t bpc_get(BPC_CONN *handle, char *buf, size_t count);
int bpc_copy(BPC_CONN *handle, bpc_mode_t mode, int fd);
int bpc_copyfile(BPC_CONN *handle, struct bpc_fileinfo *src, const char *dest);
int bpc_get_close(BPC_CONN *handle);

#endif
