#include "compat.h"
#include "backuppcd-common.h"

int backuppc_mkdir(const char *dir) {
	char *dircpy, *tmp;;
	int retval;

#ifdef MKDIR_TAKES_ONE_ARG
	if (mkdir(dir) < 0) {
#else
	if (mkdir(dir, 0700) < 0) {
#endif
		dircpy = strdup(dir);

		tmp = dircpy;

		while (1) {
			tmp = strchr(tmp + 1, '/');
			if (!tmp) {
				break;
			}

			*tmp = '\0';
#ifdef MKDIR_TAKES_ONE_ARG
			mkdir(dircpy);
#else
			mkdir(dircpy, 0700);
#endif
			*tmp = '/';
		}

		free(dircpy);

#ifdef MKDIR_TAKES_ONE_ARG
		retval = mkdir(dir);
#else
		retval = mkdir(dir, 0700);
#endif
	} else {
		retval = 0;
	}

	return(retval);
}
