#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <libbackuppcd.h>

#define BPC_CLIENT_LIST 0
#define BPC_CLIENT_GET 1

int main(int argc, char **argv) {
	BPC_CONN *conn;
	struct bpc_fileinfo *finfo = NULL;
	char *host, *port_str, *command, *username, *password;
	char *localfile;
	int port;
	int mode;
	int ret;
	char type_string[][7] = {"dir", "file", "syml", "sock", "fifo", "blk", "chr", "hrdl"};

	if (argc != 6) {
		printf("Usage: backuppcd-client <host> <port> <username> <password> {GET|LIST}\n");
		return(EXIT_FAILURE);
	}

	host = argv[1];
	port_str = argv[2];
	username = argv[3];
	password = argv[4];
	command = argv[5];

	port = strtoul(port_str, NULL, 10);

	conn = bpc_connect(host, port, username, password);
	if (!conn) {
		fprintf(stderr, "Failed (connect)\n");
		return(EXIT_FAILURE);
	}

	if (strcasecmp(command, "list") == 0) {
		mode = BPC_CLIENT_LIST;
	} else if (strcasecmp(command, "get") == 0) {
		mode = BPC_CLIENT_GET;
	} else {
		fprintf(stderr, "Invalid operation: %s\n", command);
		return(EXIT_FAILURE);
	}

	/*
	 * Begin operation
	 */
	switch (mode) {
		case BPC_CLIENT_LIST:
			ret = bpc_list_open(conn, "/", 1, NULL, NULL);
			break;
		case BPC_CLIENT_GET:
			ret = bpc_get_open(conn, "/", 1, NULL, NULL);
			break;
	}

	if (!ret) {
		fprintf(stderr, "Failed (open)\n");
		return(EXIT_FAILURE);
	}

	/*
	 * Process every entry.
	 */
	while (1) {
		switch (mode) {
			case BPC_CLIENT_LIST:
				finfo = bpc_list(conn);
				break;
			case BPC_CLIENT_GET:
				finfo = bpc_get_head(conn);
				break;
		}

		if (!finfo) {
			printf("--- end ---\n");
			break;
		}

		printf("[%4s] %06o %6lu %6lu %10llu %12lu %s",
		       type_string[finfo->type],
		       (unsigned int) finfo->mode,
		       (unsigned long) finfo->uid,
		       (unsigned long) finfo->gid,
		       (unsigned long long) finfo->size,
		       (unsigned long) finfo->mtime,
		       finfo->name);
		if (finfo->type == BPC_FILE_SYMLINK || finfo->type == BPC_FILE_HRDLINK) {
			printf(" -> %s", finfo->linkdest);
		}
		printf("\n");

		if (mode != BPC_CLIENT_GET) {
			continue;
		}

		localfile = finfo->name + 1;

		ret = bpc_copyfile(conn, finfo, localfile);

		if (!ret) {
			printf("---- failed during file copy ----\n");
			break;
		}
	}

	/*
	 * Cleanup
	 */
	switch (mode) {
		case BPC_CLIENT_LIST:
			ret = bpc_list_close(conn);
			break;
		case BPC_CLIENT_GET:
			ret = bpc_get_close(conn);
			break;
	}

	if (!ret) {
		fprintf(stderr, "Failed (close).\n");
		return(EXIT_FAILURE);
	}

	bpc_disconnect(conn);

	fprintf(stderr, "Done.\n");
	return(EXIT_SUCCESS);
}
