#ifndef _RSK_BACKUPPCD_H
#define _RSK_BACKUPPCD_H
/*
 * Copyright (C) 2005  Roy Keene
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Author Information
 *      Roy Keene
 *      Planning Systems Inc
 *      Slidell, LA
 *      backuppcd-bugs@psislidell.com
 */

#include "compat.h"

#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif
#ifdef HAVE_INTTYPES_H
#include <inttypes.h>
#endif
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SIGNAL_H
#include <signal.h>
#endif
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#ifdef HAVE_DIRENT_H
#include <dirent.h>
#endif
#ifdef HAVE_CTYPE_H
#include <ctype.h>
#endif
#ifdef HAVE_ASSERT_H
#include <assert.h>
#endif
#ifdef HAVE_STDARG_H
#include <stdarg.h>
#endif
#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif
#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif
#ifdef HAVE_LIBCONFIG
#include <libconfig.h>
#endif
#ifdef HAVE_LIBOPENNET
#include <opennet.h>
#endif
#ifdef HAVE_SYSLOG_H
#include <syslog.h>
#endif
#ifdef HAVE_TIME_H
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif
#endif

#ifdef HAVE_LIBSSL
#ifndef NO_SSL
#if defined(HAVE_OPENSSL_SSL_H)
#include <openssl/ssl.h>
#elif defined(HAVE_SSL_SSL_H)
#include <ssl/ssl.h>
#elif defined(HAVE_SSL_H)
#include <ssl.h>
#else
#define NO_SSL 1
#endif
#endif
#else
#define NO_SSL 1
#endif

#ifndef NO_SSL
#define SSL 1
#else
#undef SSL
#endif

#ifndef HAVE_HTONLL
#include "htonll.h"
#endif
#ifndef HAVE_NTOHLL
#include "ntohll.h"
#endif

/*
 * These define the values that we send and recieve over the wire denoting
 * what type of file is beiNg referenced.
 *
 * Must fit inside a uint8_t
 */
typedef enum {
	BPC_DIRENT_DIR = 0,
	BPC_DIRENT_FILE = 1,
	BPC_DIRENT_SYMLINK = 2,
	BPC_DIRENT_SOCKET = 3,
	BPC_DIRENT_FIFO = 4,
	BPC_DIRENT_BDEV = 5,
	BPC_DIRENT_CDEV = 6,
	BPC_DIRENT_HRDLINK = 7,
	BPC_DIRENT_UNKNOWN = 255
} backuppc_dirent_type_t;

/*
 * These define the values for each command sent and recieved over the wire.
 * Reply messages have their high-bit set.
 *
 * Must fit inside a uint8_t
 */
typedef enum {
	BPC_CMD_NONE = 0,
	BPC_CMD_AUTH = 1,
	BPC_CMD_SSL = 2,
	BPC_CMD_KEY = 3,
	BPC_CMD_LIST = 4,
	BPC_CMD_GET = 5,
	BPC_CMD_PUT = 6,
	BPC_CMD_RDGET = 7,
	BPC_CMD_AUTH_REPLY = (BPC_CMD_AUTH | 0x80),
	BPC_CMD_SSL_REPLY = (BPC_CMD_SSL | 0x80),
	BPC_CMD_KEY_REPLY = (BPC_CMD_KEY | 0x80),
	BPC_CMD_LIST_REPLY = (BPC_CMD_LIST | 0x80),
	BPC_CMD_GET_REPLY = (BPC_CMD_GET | 0x80),
	BPC_CMD_PUT_REPLY = (BPC_CMD_PUT | 0x80),
	BPC_CMD_RDGET_REPLY = (BPC_CMD_RDGET | 0x80),
} backuppc_cmd_t;

/*
 * These define the values we send and recieve over the wire to describe each
 * attribute for a referenced file.
 *
 * Must fit inside a uint16_t
 */
typedef enum {
	BPC_ATTRID_NOP = 0,
	BPC_ATTRID_MTIME = 1,
	BPC_ATTRID_CTIME = 2,
	BPC_ATTRID_USER = 3,
	BPC_ATTRID_GROUP = 4,
	BPC_ATTRID_UID = 5,
	BPC_ATTRID_GID = 6,
	BPC_ATTRID_MD5 = 7,
	BPC_ATTRID_ACL = 8,
	BPC_ATTRID_PACL = 9,
	BPC_ATTRID_NTACL = 10,
	BPC_ATTRID_SYMLINKDEST = 11,
	BPC_ATTRID_HRDLINKDEST = 12,
} backuppc_attrid_t;

/*
 * These are used for short status messages.
 *
 * Must fit inside a uint8_t
 */
typedef enum {
	BPC_STATUS_OKAY = 0,
	BPC_STATUS_FAILED = 1,
	BPC_STATUS_UNKNOWN = 255
} backuppc_status_t;

#define BPC_ACL_XOTH 00001
#define BPC_ACL_WOTH 00002
#define BPC_ACL_ROTH 00004
#define BPC_ACL_XGRP 00010
#define BPC_ACL_WGRP 00020
#define BPC_ACL_RGRP 00040
#define BPC_ACL_XUSR 00100
#define BPC_ACL_WUSR 00200
#define BPC_ACL_RUSR 00400
#define BPC_ACL_STCK 01000
#define BPC_ACL_SGID 02000
#define BPC_ACL_SUID 04000

#define BPC_OPT_RECURSIVE 0x01
#define BPC_OPT_MD5       0x02
#define BPC_OPT_SHA1      0x04

#endif
