#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <map>
using namespace std;

#ifndef ARPDEV
#define ARPDEV "/proc/net/arp"
#endif
#ifndef ARPSCP
#define ARPSCP "./arp-poisoner"
#endif

void arp_conflict(string ip, string oldhwaddr, string newhwaddr, map<string, string> &arplist) {
	string check_ip, check_hwaddr;
	map<string, string>::iterator cur = arplist.begin();
	map<string, string>::iterator last = arplist.end();
	stringstream arpscript;

	cerr << "***ARP CONFLICT*** " << ip << " changed from " << oldhwaddr << " to " << newhwaddr << "\n";
	while (cur!=last) {
		check_ip=(*cur).first;
		check_hwaddr=arplist[check_ip];
		if (check_hwaddr==newhwaddr && ip!=check_ip) {
			arpscript << ARPSCP << " \"" << check_ip << "\" \"" << check_hwaddr << "\" \"" << ip << "\" \"" << oldhwaddr << "\"";
			cerr << "Running: " << arpscript.str().c_str() << "\n";
			system(arpscript.str().c_str());
		}
		cur++;
	}
	if (arpscript.str()=="") {
		arpscript << ARPSCP << " \"\" \"" << newhwaddr << "\" \"" << ip << "\" \"" << oldhwaddr << "\"";
	}
	cerr << "Running: " << arpscript.str().c_str() << "\n";
	system(arpscript.str().c_str());

	return;
}

int update_arplist(map<string, string> &arplist) {
	ifstream arpdev;
	string ip, hw_type, flags, hw_addr, mask, dev;
	char buf[1024];

	arpdev.open(ARPDEV);
	if (!arpdev.is_open()) {
		return(1);
	}

	/* Read header, to ignore. */
	arpdev.getline(buf, sizeof(buf));

	while (!arpdev.eof()) {
		/* Read data */
		if (!(arpdev >> ip >> hw_type >> flags >> hw_addr >> mask >> dev)) break;

		/* Ignore ARP entries whose flags are not 0x2 (norm) and 0x6 (PERM) */
		if (flags!="0x2" && flags!="0x6") continue;

		/* If there's a change, do something */
		if (arplist[ip]!=hw_addr) {
			if (arplist[ip]=="") {
				/* If it's a new entry, add it and continue. */
				arplist[ip]=hw_addr;
			} else {
				/* If it's an old entry, but with a different MAC addr, report it. */
				arp_conflict(ip, arplist[ip], hw_addr, arplist);
			}
		}
	}
	arpdev.close();

	return(0);
}

int main(int argc, char **argv) {
	map<string, string> arplist;
	pid_t childpid;

	/* Daemonize ourselves. */
	childpid=fork();
	if (childpid<0) {
		perror("fork");
		return(1);
	}
	if (childpid!=0) {
		/* Parent */
		waitpid(childpid, NULL, 0);
		return(0);
	} else {
		/* Child */
		childpid=fork();
		if (childpid<0) return(1);
		if (childpid!=0) {
			/* Child, still */
			return(0);
		}
	}
	/* Grandchild */

	while (1) {
		update_arplist(arplist);
		sleep(30);
	}

	return(0);
}
